/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.intercompatibility;

import com.mojang.blaze3d.platform.InputConstants;
import de.maxhenkel.voicechat.events.ClientVoiceChatConnectedEvent;
import de.maxhenkel.voicechat.events.ClientVoiceChatDisconnectedEvent;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.Connection;
import net.minecraft.server.packs.repository.RepositorySource;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class NeoForgeClientCompatibilityManager
extends ClientCompatibilityManager {
    private final List<ClientCompatibilityManager.RenderNameplateEvent> renderNameplateEvents = new CopyOnWriteArrayList<ClientCompatibilityManager.RenderNameplateEvent>();
    private final List<ClientCompatibilityManager.RenderHUDEvent> renderHUDEvents = new CopyOnWriteArrayList<ClientCompatibilityManager.RenderHUDEvent>();
    private final List<ClientCompatibilityManager.KeyboardEvent> keyboardEvents = new CopyOnWriteArrayList<ClientCompatibilityManager.KeyboardEvent>();
    private final List<ClientCompatibilityManager.MouseEvent> mouseEvents = new CopyOnWriteArrayList<ClientCompatibilityManager.MouseEvent>();
    private final List<Runnable> clientTickEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> inputEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> disconnectEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> joinWorldEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Consumer<ClientVoicechatConnection>> voicechatConnectEvents = new CopyOnWriteArrayList<Consumer<ClientVoicechatConnection>>();
    private final List<Runnable> voicechatDisconnectEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Consumer<Integer>> publishServerEvents = new CopyOnWriteArrayList<Consumer<Integer>>();
    private final List<RepositorySource> repositorySources = new CopyOnWriteArrayList<RepositorySource>();
    private final List<KeyMapping> keyMappings = new CopyOnWriteArrayList<KeyMapping>();
    private boolean wasPublished;

    @SubscribeEvent
    public void onRenderName(RenderNameTagEvent.DoRender event) {
        this.renderNameplateEvents.forEach(renderNameplateEvent -> renderNameplateEvent.render(event.getEntityRenderState(), event.getCameraRenderState(), event.getPoseStack(), event.getSubmitNodeCollector()));
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGuiLayerEvent.Post event) {
        if (!VanillaGuiLayers.HOTBAR.equals((Object)event.getName())) {
            return;
        }
        this.renderHUDEvents.forEach(renderHUDEvent -> renderHUDEvent.render(event.getGuiGraphics(), event.getPartialTick().getRealtimeDeltaTicks()));
    }

    @SubscribeEvent
    public void onKey(InputEvent.Key event) {
        this.keyboardEvents.forEach(keyboardEvent -> keyboardEvent.onKeyboardEvent(event.getKeyEvent()));
    }

    @SubscribeEvent
    public void onMouse(InputEvent.MouseButton.Pre event) {
        this.mouseEvents.forEach(mouseEvent -> mouseEvent.onMouseEvent(event.getMouseButtonInfo(), event.getAction()));
    }

    @SubscribeEvent
    public void onKeyInput(ClientTickEvent.Pre event) {
        this.clientTickEvents.forEach(Runnable::run);
        this.inputEvents.forEach(Runnable::run);
    }

    @SubscribeEvent
    public void onDisconnect(LevelEvent.Unload event) {
        if (Minecraft.getInstance().gameMode == null) {
            this.disconnectEvents.forEach(Runnable::run);
        }
    }

    @SubscribeEvent
    public void onJoinServer(ClientPlayerNetworkEvent.LoggingIn event) {
        if (event.getPlayer() != Minecraft.getInstance().player) {
            return;
        }
        this.joinWorldEvents.forEach(Runnable::run);
    }

    @SubscribeEvent
    public void onServer(ServerTickEvent.Post event) {
        IntegratedServer server = Minecraft.getInstance().getSingleplayerServer();
        if (server == null) {
            return;
        }
        boolean published = server.isPublished();
        if (published && !this.wasPublished) {
            this.publishServerEvents.forEach(portConsumer -> portConsumer.accept(server.getPort()));
        }
        this.wasPublished = published;
    }

    public void onRegisterKeyBinds(RegisterKeyMappingsEvent event) {
        for (KeyMapping mapping : this.keyMappings) {
            event.register(mapping);
        }
    }

    public void onAddPackFindersEvent(AddPackFindersEvent event) {
        for (RepositorySource repositorySource : this.repositorySources) {
            event.addRepositorySource(repositorySource);
        }
    }

    @Override
    public void onRenderNamePlate(ClientCompatibilityManager.RenderNameplateEvent onRenderNamePlate) {
        this.renderNameplateEvents.add(onRenderNamePlate);
    }

    @Override
    public void onRenderHUD(ClientCompatibilityManager.RenderHUDEvent onRenderHUD) {
        this.renderHUDEvents.add(onRenderHUD);
    }

    @Override
    public void onKeyboardEvent(ClientCompatibilityManager.KeyboardEvent onKeyboardEvent) {
        this.keyboardEvents.add(onKeyboardEvent);
    }

    @Override
    public void onMouseEvent(ClientCompatibilityManager.MouseEvent onMouseEvent) {
        this.mouseEvents.add(onMouseEvent);
    }

    @Override
    public void onClientTick(Runnable onClientTick) {
        this.clientTickEvents.add(onClientTick);
    }

    @Override
    public InputConstants.Key getBoundKeyOf(KeyMapping keyBinding) {
        return keyBinding.getKey();
    }

    @Override
    public void onHandleKeyBinds(Runnable onHandleKeyBinds) {
        this.inputEvents.add(onHandleKeyBinds);
    }

    @Override
    public KeyMapping registerKeyBinding(KeyMapping keyBinding) {
        this.keyMappings.add(keyBinding);
        return keyBinding;
    }

    @Override
    public void emitVoiceChatConnectedEvent(ClientVoicechatConnection client) {
        this.voicechatConnectEvents.forEach(consumer -> consumer.accept(client));
        NeoForge.EVENT_BUS.post((Event)new ClientVoiceChatConnectedEvent(client));
    }

    @Override
    public void emitVoiceChatDisconnectedEvent() {
        this.voicechatDisconnectEvents.forEach(Runnable::run);
        NeoForge.EVENT_BUS.post((Event)new ClientVoiceChatDisconnectedEvent());
    }

    @Override
    public void onVoiceChatConnected(Consumer<ClientVoicechatConnection> onVoiceChatConnected) {
        this.voicechatConnectEvents.add(onVoiceChatConnected);
    }

    @Override
    public void onVoiceChatDisconnected(Runnable onVoiceChatDisconnected) {
        this.voicechatDisconnectEvents.add(onVoiceChatDisconnected);
    }

    @Override
    public void emitDisconnectedEvent() {
        this.disconnectEvents.forEach(Runnable::run);
    }

    @Override
    public void onDisconnect(Runnable onDisconnect) {
        this.disconnectEvents.add(onDisconnect);
    }

    @Override
    public void onJoinWorld(Runnable onJoinWorld) {
        this.joinWorldEvents.add(onJoinWorld);
    }

    @Override
    public void onPublishServer(Consumer<Integer> onPublishServer) {
        this.publishServerEvents.add(onPublishServer);
    }

    @Override
    public SocketAddress getSocketAddress(Connection connection) {
        return connection.channel().remoteAddress();
    }

    @Override
    public void addResourcePackSource(RepositorySource repositorySource) {
        this.repositorySources.add(repositorySource);
    }
}

